/**
* \file: GstreamerVideoSinkImpl.h
*
* \version: 1.0
*
* \release: $Name:$
*
* Actuall implementation of GstreamerVideoSink class.
*
* \component: Baidu CarLife
*
* \author: P. Govindaraju / RBEB/GM / Pradeepa.Govindaraju@in.bosch.com
*
* \copyright (c) 2017 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
************************************************************************/

#ifndef BDCL_GSTREAMERVIDEOSINKIMPL_H_
#define BDCL_GSTREAMERVIDEOSINKIMPL_H_

#include <uspi/EndpointDataSharing.h>
#include <bdcl/BaiduCoreCallbackDealer.h>
#include <bdcl/AditVideoSink.h>
#include <bdcl/AditBackendCallbacks.h>
#include <bdcl/CCarLifeLib.h>
#include "GstreamerVideoPipeline.h"
#include "GstreamerVideoSinkConfig.h"
namespace adit{ namespace bdcl{

class GstreamerVideoSinkImpl : public IVideoSinkBackendCallbacks
{
public:
    GstreamerVideoSinkImpl(IAditVideoSinkCallbacks* inCallbacks, CoreCallbackDealer* inCallbackDealer);
    virtual ~GstreamerVideoSinkImpl();

    void setConfigItem(std::string inKey, std::string inValue);

    bool initialize();
    void teardown();

    void configureStream();
    bool playbackStart();
    void playbackPause();

    //IVideoSinkBackendCallbacks
    void onVideoDataAvailable(uint8_t *data, uint32_t len);

    static void firstFrameRenderedHandler(GstElement * element, GstPad *pad, gpointer user_data);
    struct wl_display* mDisplay;

private:
    GstreamerVideoPipeline mVideoPipeline;
    GstreamerVideoSinkConfig mConfig;
    IAditVideoSinkCallbacks* mCallbacks;
    CoreCallbackDealer* mCallbackDealer;

    bool mIsSetThreadParam;
    unsigned long firstFrameRenderedHandlerId;
    bool firstFrameRendered;
    static void* sessionContext;
    S_VIDEO_ENCODER_INIT initVideoParam;

    void _setThreadPriority();
};

} } /*namespace adit { namespace bdcl {*/

#endif /* BDCL_GSTREAMERVIDEOSINKIMPL_H_ */
